#include <Arduino.h>

const int pinWarm = 2;
const int pinWhite = 3;
const int pinBlue= 4;
const int pinGreen = 5;
const int pinRed = 6;

const int statusLed = 13;
const int writeLed = 12;

// Controller
const int pot[] = {26, 27, 28, 29}; // Potmeter
uint16_t potValue[4];
bool useController = false;



// Timer
const byte timer_amount = 7;       // How many timers
unsigned long timer[timer_amount];                // Array for the timers
float duration[timer_amount];             // Array for storing the timer duration in ms, float because it has micros resolution
bool bang[timer_amount];

const byte refreshLED = 0;
const byte refreshController = 1;
const byte ledChan1 = 2;
const byte ledChan2 = 3;
const byte ledChan3 = 4;
const byte ledChan4 = 5;
const byte fadeSpeed = 6;


uint16_t currentLEDbrightness[4];    // how bright the LED is
uint16_t gotoLEDbrightness[4];    // how bright the LED is

uint16_t pwmOUT[4];    // PWM OUT


// Constants for 16-bit PWM
int max_pwm = 65535;
const int minBrightness = 50;
float n = 2.5; //adjust exponent for smoothnes
int fade_steps = 1000;  // Number of steps in the fade

void setup() {
  
  Serial.begin(115200);
  Serial.println("Running");

  pinMode(statusLed, OUTPUT);
  pinMode(writeLed, OUTPUT);
  pinMode(pinRed, OUTPUT);
  pinMode(pinGreen, OUTPUT);
  pinMode(pinBlue, OUTPUT);
  pinMode(pinWhite, OUTPUT);
  pinMode(pinWarm, OUTPUT);


  // Potmeter controlle
  pinMode(pot[0], INPUT);
  pinMode(pot[1], INPUT);
  pinMode(pot[2], INPUT);
  pinMode(pot[3], INPUT);
   unsigned int readControllerPin = analogRead(pot[0]) + analogRead(pot[1]) + analogRead(pot[2]) + analogRead(pot[3]); // Check controller
  if (readControllerPin < 3600) {
    useController = true;
    Serial.println("Controller detected");
    duration[fadeSpeed] = 1; // Fade with controller ms
    

  } else {
    Serial.println("No controller detected");
    duration[fadeSpeed] = 2; // Fade without controller ms
    gotoLEDbrightness[3] = 65535;
  }

 duration[refreshLED] = 1; // refresh led in ms
  duration[refreshController] = 10; // refresh controller
  duration[ledChan1] = 13000; // cycle LED
  duration[ledChan2] = 17000; // cycle LED
  duration[ledChan3] = 11000; // cycle LED
  duration[ledChan4] = 19000; // cycle LED


   digitalWrite(statusLed, HIGH);

  // Adjust PWM properties if needed
  analogWriteFreq(1000); // 5000
  analogWriteRange(65535);
  analogWriteResolution(16);

}





void keepTime() {
  // Run all the timers
  // Return a bang if the time set in duration is reached
  // For example if timer[1] with duration[1] = 1000ms is reached it returns a bang[1] = true
  for (byte i = 0; i < timer_amount; i++) {
    bang[i] = LOW;
    unsigned long maxtimeDuration = duration[i] * 1000; // We're working with micros timers
    if (micros() - timer[i] > maxtimeDuration) {
      bang[i] = HIGH;
      timer[i] = micros();
    }
  }
}



void readController() {
  if (useController) {
    if (bang[refreshController]) {
      // read the input on analog pins
      int sensorValue[4];

      // Non linear response
      for (int i = 0; i < 4; i++) {
        int potRead = analogRead(pot[i]) * 1.1 - 35;
        potRead = constrain(potRead, 0, 1023);
        if (potRead < 300) {
          potValue[i] = potRead * 2;
        } else if (potRead < 700) {
          potValue[i] = map(potRead, 300, 700, 600, 15000);
        } else {
          potValue[i] = map(potRead, 700, 1023, 15000, 65535);
        }
        gotoLEDbrightness[i] = potValue[i];

      }
    }

    if (bang[fadeSpeed]) {

      for (int i = 0; i < 4; i++) {
        // Move leds to new values
        if ( currentLEDbrightness[i] < gotoLEDbrightness[i]) {
          currentLEDbrightness[i]++;
          if (currentLEDbrightness[i] > 100 && currentLEDbrightness[i] < 65535 && (gotoLEDbrightness[i] - currentLEDbrightness[i]) > 400 ) {
            currentLEDbrightness[i] += round((gotoLEDbrightness[i] - currentLEDbrightness[i]) * 0.0035);
          }
        }
        if ( currentLEDbrightness[i] > gotoLEDbrightness[i]) {
          currentLEDbrightness[i]--;
          if (currentLEDbrightness[i] > 100 && (currentLEDbrightness[i] - gotoLEDbrightness[i]) > 400 ) {
            currentLEDbrightness[i] -= round((currentLEDbrightness[i] - gotoLEDbrightness[i]) * 0.0035);
          }
        }
      }
    }
  }
}



void cycleLED() {
  // If there's no controller, default to random cycles
  if (!useController) {

// Check if all channels are off, and reset them
    bool allLEDSOff = true;
    for (int i = 0; i < 4; i++) {
      // New values
      if (currentLEDbrightness[i] != 0) {
        allLEDSOff = false;
      }
    }
    if (allLEDSOff) {
      int coinFlip = random(2);
      bang[2 + coinFlip] = true;
    }



    for (int i = 0; i < 4; i++) {
      // New values

      if (bang[i + 2]) {
        int coinFlip = random(5);
        if (coinFlip == 0) {
          gotoLEDbrightness[i] = random(0, 1000);
        } else if (coinFlip == 1) {
          gotoLEDbrightness[i] = random(500, 1000);
        } else if (coinFlip == 2) {
          gotoLEDbrightness[i] = 0;
        } else {
          if (currentLEDbrightness[i] < 100) {
            gotoLEDbrightness[i] = random(500, 1000);
          } else {
            gotoLEDbrightness[i] = 0;
          }
        }

        Serial.print("New value ");
        Serial.print(i);
        Serial.print(": ");
        Serial.println(gotoLEDbrightness[i]);


      }
    }

    if (bang[2]) {
      int coinFlip1 = random(3);
      if (coinFlip1 == 1) {
        for (int i = 0; i < 3; i++) {
          gotoLEDbrightness[i] = 0;
        }
      }
    }


    if (bang[fadeSpeed]) {
      for (int i = 0; i < 4; i++) {
        // Move leds to new values
        if ( currentLEDbrightness[i] < gotoLEDbrightness[i]) {
          currentLEDbrightness[i]++;
        }
        if ( currentLEDbrightness[i] > gotoLEDbrightness[i]) {
          currentLEDbrightness[i]--;
        }
      }
    }
  }

}


void loop() {


  keepTime();
  readController();
  cycleLED();
  

for(int i = 0; i < 4; i++){

float x = currentLEDbrightness[i] / 1000;
pwmOUT[i] = int(max_pwm * pow(x, n));


}

     analogWrite(pinRed, pwmOUT[0]);
     analogWrite(pinGreen, pwmOUT[1]);
     analogWrite(pinBlue, pwmOUT[2]);
     analogWrite(pinWhite, pwmOUT[3]);


}