#include <Arduino.h>
#include <Adafruit_NeoPixel.h>
#include <Adafruit_MCP4728.h>
#include <Wire.h>
#include "Deneyap_RenkDonusturme.h"


// Wire
// in setup


#define SAT_PIN     A1
#define HUE_PIN     A2
#define BRIGHT_PIN  A3

#define XY_PIN     A0
#define ADC_SELECT 25


#define LED_PIN     14

// How many NeoPixels are attached to the Arduino?
#define LED_COUNT  1

// NeoPixel brightness, 0 (min) to 255 (max)
#define BRIGHTNESS 50 // Set BRIGHTNESS to about 1/5 (max = 255)

// Declare our NeoPixel strip object:
Adafruit_NeoPixel strip(LED_COUNT, LED_PIN, NEO_RGB + NEO_KHZ800);

// Declare our DAC
Adafruit_MCP4728 mcp;


void setup() {
  

  pinMode(ADC_SELECT, OUTPUT);
  digitalWrite(ADC_SELECT, HIGH);  

  Wire.setSDA(16);
  Wire.setSCL(17);
  Wire.begin();

  
  Serial.begin(115200);
  Serial.println("Running");

  
  strip.begin();           // INITIALIZE NeoPixel strip object (REQUIRED)
  strip.show();            // Turn OFF all pixels ASAP
  strip.setBrightness(BRIGHTNESS);
  strip.setPixelColor(255, 0, 0, 20); // turn on led
  strip.show();

  Serial.println("Led on!");


  Serial.println("Adafruit MCP4728 test!");

  if (!mcp.begin()) { 
        Serial.println("Failed to find MCP4728 chip");
    }

    
 mcp.setChannelValue(MCP4728_CHANNEL_A, 4095);
 mcp.setChannelValue(MCP4728_CHANNEL_B, 2048);
 mcp.setChannelValue(MCP4728_CHANNEL_C, 1024);
 mcp.setChannelValue(MCP4728_CHANNEL_D, 100);
 Serial.println("MCP4728 running..");
        
analogReadResolution(12);

}



/**
 * splitColor() - Receive a uint32_t value, and spread into bits.
 */
uint8_t splitColor ( uint32_t c, char value )
{
  switch ( value ) {
    case 'r': return (uint8_t)(c >> 16);
    case 'g': return (uint8_t)(c >>  8);
    case 'b': return (uint8_t)(c >>  0);
    default:  return 0;
  }
}

int count = 0;


void loop() {

   //Serial.println("on!");

//      strip.setPixelColor(0, 0, 0, 255); // turn on led
//    strip.show();

//  delay(500);


//   Serial.println("on!");

//     strip.setPixelColor(0, 0, 255, 0); // turn on led
//    strip.show();
  
 // delay(250);

 
int HuePot = analogRead(HUE_PIN);
int SatPot = analogRead(SAT_PIN);
int BrightPot = analogRead(BRIGHT_PIN);



//  Serial.print("Hue: ");
//  Serial.print(HuePot);

//  Serial.print(" Sat: ");
//  Serial.print(SatPot);

//  Serial.print(" Bright: ");
//  Serial.print(BrightPot);

//     Serial.println();


int adcHue = map(analogRead(HUE_PIN), 0, 4095, 0, 65535);
int adcSaturation = map(analogRead(SAT_PIN), 0, 4095, 0, 255);
int adcBright = map(analogRead(BRIGHT_PIN), 0, 4095, 0, 255);


uint32_t rgbcolor = strip.ColorHSV(adcHue, adcSaturation, adcBright);

count++;
if(count > 10){
  count = 0;
strip.setPixelColor(0, rgbcolor);
strip.show();
}


int rV = splitColor(rgbcolor, 'g') * 16;
int gV = splitColor(rgbcolor, 'r') * 16;
int bV = splitColor(rgbcolor, 'b') * 16;

//  Serial.print("R: ");
//  Serial.print(rV);

//  Serial.print(" G: ");
//  Serial.print(gV);

//  Serial.print(" B: ");
//  Serial.print(bV);

//     Serial.println();




   mcp.setChannelValue(MCP4728_CHANNEL_A, rV); // red
   mcp.setChannelValue(MCP4728_CHANNEL_B, gV);
   mcp.setChannelValue(MCP4728_CHANNEL_C, bV);
  // mcp.setChannelValue(MCP4728_CHANNEL_D, intensity);

  // Print the analog value (range: 0-1023)
//   Serial.print("ADC Values: ");
//    Serial.print("H:");
//   Serial.print(adcHue);
//    Serial.print(", S:");
//   Serial.print(adcSaturation);
//    Serial.print(", B:");
//   Serial.println(adcBright);


 delay(1);



}